#ifndef COLLIDE_H
#define COLLIDE_H

using namespace std;

#include <GL/glu.h>
#include <GL/OpenGlut.h>

#include <vector>
#include "Vecteur.h"
#include "Physique.h"
#include "CTerrainSplited.h"

class CMoteurCollide;

#define IN_LIFE 1
#define IS_REF 2
#define IS_REC 4

//Objet physique fixe
class CCollide
{
    friend class CMoteurCollide;
    
    protected:
        unsigned char dmg,colid_flags;
        
        float rayon;//rayon de la sphre englobante
        float coefElastic;//coef de rebon
        
        Vecteur pos;//position de l'objet
        
        bool isNotFixed;//pour savoir si l'objet est fixe ou non  cause des hritage virtuel defaon  simplifier les appels
        
        //Fonction "callabck" en cas d'impact
        virtual void applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse,unsigned char dmg);
        virtual void applyExplosion(float dmg,float proxi);
        
        //MAJ et render
        virtual bool frameMove(float elapsedTime);
        virtual void render();
        
    public:
        CCollide(float px,float py,float pz,float rayon,float coefElastic);
        
        virtual ~CCollide();
        
        //Changer des drapeaux du collide (si il est vivant ou non etc...)
        void cldEnable(unsigned char colid_flags);
        void cldDisable(unsigned char colid_flags);
};

//Objet physique en mouvement
class CCollideMv : public CCollide
{
    friend class CMoteurCollide;
    
    protected:
        float ffrot;//force de frottement
        float masse;//masse de l'objet
        
        Vecteur force,vel;//vitesse et force
        
        virtual void applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse);
        virtual void applyExplosion(float dmg,float proxi);
        
        virtual bool frameMove(float elapsedTime);
        virtual void render();
        
    public:
        CCollideMv(float px,float py,float pz,float fx,float fy,float fz,float vx,float vy,float vz,float masse,float rayon,float coefElastic,float ffrot);
        
        virtual ~CCollideMv();
};

//Objet qui dfinit une zone en combustion
//tout objet physique qui y passe doit subir des dgats
class CExplosion
{
    friend class CMoteurCollide;
    
    protected:
        Vecteur pos;//position
        float rayon;//rayon d'action
        float dmg;//taux de dgat
        
        float life;//dur de vie en milliseconde
        
        virtual bool frameMove(float elapsedTime);
        virtual void render();
        
    public:
        CExplosion(float px,float py,float pz,float rayon,float dmg,float life);
        virtual ~CExplosion();
};

//Moteur de collisions
class CMoteurCollide
{
    private:
        //liste des collide ne attente d'tre ajout
        //le risque c'est d'ajouter des missiles durrant le parcour des collides et donc
        //tout plante !
        vector<CCollide*> vectCollTT;
        vector<CCollide*> vectColl;//liste de collide
        vector<CExplosion*> vectExplo;//liste d'explosion
        
        //liste d'explostion en attente car les collides explosent durrant le parcour des explosions
        vector<CExplosion*> vectExploTT;
        vector<CCollide*> vectLsr;//liste des objets  rendre en dernier
        
        //calcul de la collision la plus proche dans une intervalle de temps donne
        //cld1 et cld2 sont  les collides en collision
        CCollide *cld1,*cld2;
        float getTheNearestCollision(float elapsedTime);
        
        float gravity;
        
        CTerrainSplited *tr;//terrain pour rectifier les hauteurs
        
    public:
        CMoteurCollide();
        ~CMoteurCollide();
        
        void frameMove(float elapsedTime);
        void render(float posix);
        void renderTransparent(float posix);
        
        void addCollide(CCollide *cld);
        void addCollideSf(CCollide *cld);//Safe pour le mettre en liste d'attente
        void addExplosion(CExplosion *cld);
        void addLaser(CCollide *cld);
        
        void clear();
        
        void setGravity(float gravity);
        void setTerrain(CTerrainSplited *tr);
        
        //Pour les missiles  tte chercheuses. d est modifi si le missile  bien une cible.
        bool getDirSearchingHead(CCollide *me,Vecteur &d,float sqrDistAct,float coefAct,float projSpeed);
};

#endif
